#include "hal_base.h"
#include "hal_gpio.h"
#include "hal_uart.h"
#include "hal_irq.h"


uint8_t recv_data;		// յֵ
uint8_t send_data;		// ͵ֵ

/* ʼPB4 TX, PB5 RX */
void GPIO_init(void)
{
	gpio_init_t init;
	init.io = GPIO_OUTPUT;
	init.level = GPIO_LOW_LEVEL;
	init.mode = GPIO_DIGIT_MODE;
	init.pu = DISABLE;
	init.pd = DISABLE;
	init.drive = GPIO_LOW_DRIVER;
	init.od = DISABLE;
	init.smit = GPIO_1_5_TO_3_0_SMIT;
	init.cur_ctr = DISABLE;
	gpio_init(PB_TYPE, GPIO_PIN_4, &init);

	init.io = GPIO_INPUT;
	gpio_init(PB_TYPE, GPIO_PIN_5, &init);
}

void main() 
{
	// RAMʼ
	ram_clear();
	// clockʼѡHRC,Ƶʹclock 
	clock_init(CLOCK_SRC_HRC, CLOCK_DIV_1, DISABLE);
	// GPIOڳʼ
	GPIO_init();

	// ͵ֵΪ0x55
	send_data = 0x55;
	// uartʼΪ115200
	uart_init(115200);
	// ִз
	uart_tx(&send_data);

	// ѯձ־ձ־𣬱ʾuartյ */
	while (!irq_get_flag_status(RX0IE_IT))
		CLRWDT();
	// ȡյ
	recv_data = uart_rx();

	while (1) {
		// ι
		 CLRWDT();
	}

}